/*
 * Decompiled with CFR 0.152.
 */
package acmx.classfile;

import acmx.classfile.ConstantPoolEntry;
import acmx.classfile.JavaClass;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClassEntry
extends ConstantPoolEntry {
    private int nameIndex;

    protected ClassEntry(DataInputStream in, JavaClass jc) throws IOException {
        super(7, jc);
        this.nameIndex = in.readShort();
    }

    protected ClassEntry(int nameID, JavaClass jc) {
        super(7, jc);
        this.nameIndex = nameID;
    }

    public String getName() {
        return this.getOwner().getUTF8Name(this.nameIndex);
    }

    public void setName(String name) {
        this.nameIndex = this.getOwner().createUTF8Entry(name);
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.getEntryType());
        out.writeShort(this.nameIndex);
    }

    public String toString() {
        return "[Class:" + this.getName().replace('/', '.') + "]";
    }
}

